//+------------------------------------------------------------------+
//|                                                    OB trader.mq5 |
//|                                  Copyright 2025, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"

#include <Trade/Trade.mqh>


input double lotSize = 0.01;
input int Risk = 1;
CTrade m_trade;
datetime LastBarTime; 




//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
  //Idk how this works but okay
  m_trade.SetExpertMagicNumber(202669);
  
//---
   
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
   
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   datetime CurrentBarTime = iTime(_Symbol, _Period, 0);
   
   //check if a new candle started 
   if(CurrentBarTime == LastBarTime) return;
   double ask = SymbolInfoDouble(_Symbol, SYMBOL_ASK);
   
   double bsl = iLow(_Symbol, _Period, 1); //Sl 100 points below entry
   double buyDistance = (ask - bsl) * Risk;         // How much am I risking?
   double btp = ask + buyDistance;         // Add that same amount to the top (1:1)
   
   double bid = SymbolInfoDouble(_Symbol, SYMBOL_BID);
   double ssl = iHigh(_Symbol, _Period, 1); //Sl 100 points above entry
   double sellDistance = (ssl - bid) * Risk;         // How much am I risking?
   double stp = bid - sellDistance;         // Subtract that same amount from the bottom (1:1)


   
   LastBarTime = CurrentBarTime;
   
   //First lets check if its a Bullish OB candle 2 has to be bearish and candle 1 has to be bullish
   if(IsBullishOB())
   {
   
   Print("Bullish OB Detected");
   //Place Buy 
   m_trade.Buy(lotSize, _Symbol, ask, bsl, btp, "Buy Placed");
   }
   
   if(IsBearishOB())
   {
   Print("Bearish OB Detected");
   
   //Place Sell
   m_trade.Sell(lotSize, _Symbol,bid, ssl, stp, "Sell Placed");
   
  }
 }
  
//+------------------------------------------------------------------+

bool IsBullishOB()
{
   double c1 = iClose(_Symbol,_Period, 1);
   double o1  = iOpen(_Symbol, _Period, 1);
   double h1  = iHigh(_Symbol, _Period, 1);
   double l1   = iLow(_Symbol, _Period, 1);
   double c2 = iClose(_Symbol, _Period, 2);
   double o2  = iOpen(_Symbol, _Period, 2);
   double h2  = iHigh(_Symbol, _Period, 2);
   double l2   = iLow(_Symbol,  _Period, 2);
   
   return(o2 > c2 && h2 < h1 && h2 < c1 && l2 > l1 && l2 < o1);
   
}

bool IsBearishOB()
{
   double c1 = iClose(_Symbol,_Period, 1);
   double o1  = iOpen(_Symbol, _Period, 1);
   double h1  = iHigh(_Symbol, _Period, 1);
   double l1   = iLow(_Symbol, _Period, 1);
   double c2 = iClose(_Symbol, _Period, 2);
   double o2  = iOpen(_Symbol, _Period, 2);
   double h2  = iHigh(_Symbol, _Period, 2);
   double l2   = iLow(_Symbol,  _Period, 2);
   
   return(o2 < c2 && h2 < h1 && h2 > o1 && l2 > l1 && l2 > c1);
}


